<?= view('layout/header') ?>

<div class="container mt-5">
    <h2 class="mb-4 text-primary">📅 Aktivitas Harian</h2>

    <?php if ($aktivitas): ?>
        <div class="row g-4">
            <?php foreach ($aktivitas as $a): ?>
                <div class="col-md-6 col-lg-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h6 class="text-muted mb-2"><?= esc($a['tanggal']) ?> | <?= esc($a['jam']) ?></h6>
                            <h5 class="card-title"><?= esc($a['nama_aktivitas']) ?></h5>

                            <?php if ($a['media']): ?>
                                <?php
                                $mediaPath = $a['media_type'] === 'upload'
                                    ? base_url('uploads/aktivitas/' . $a['media'])
                                    : esc($a['media']);

                                $ext = pathinfo($a['media'], PATHINFO_EXTENSION);
                                $isVideo = in_array(strtolower($ext), ['mp4', 'webm', 'ogg']);
                                $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif']);
                                ?>
                                <div class="mt-3 text-center">
                                    <?php if ($isImage): ?>
                                        <img src="<?= $mediaPath ?>" class="img-fluid rounded" alt="Media Aktivitas">
                                    <?php elseif ($isVideo): ?>
                                        <video controls class="w-100 rounded">
                                            <source src="<?= $mediaPath ?>" type="video/<?= $ext ?>">
                                            Video tidak didukung browser Anda.
                                        </video>
                                    <?php else: ?>
                                        <a href="<?= $mediaPath ?>" target="_blank" class="btn btn-outline-primary btn-sm">
                                            🔗 Lihat Media
                                        </a>
                                    <?php endif ?>
                                </div>
                            <?php endif ?>
                        </div>
                    </div>
                </div>
            <?php endforeach ?>
        </div>
    <?php else: ?>
        <div class="alert alert-warning text-center">
            Data aktivitas belum tersedia.
        </div>
    <?php endif; ?>

    <div class="mt-4">
        <a href="<?= base_url('/') ?>" class="btn btn-secondary">
            ⬅ Kembali ke Home
        </a>
    </div>
</div>

<?= view('layout/footer') ?>